require( "scripts/style.lua" );
require( "scripts/chocshopstyle.lua" );
require( "scripts/transitions.lua" );

MakeDialog
{
	RWindow
	{
	    name        = "console_window",
		x			= 10, 
	    y			= 10,
        w			= 350,
	    h			= 150,
	    alpha       = true,
	    
		KSplit9Image
		{ 
			image	= "ui/backgrounds/split9_dialog_small",	
			x		= kCenter,
			y		= kCenter,
			w		= 350,
			h		= 150,
			x1		= 40,
			y1		= 40,
			x2		= 40,
			y2		= 40,
			
			---------------------------------------------- Title
			RShrinkText
			{
				x		= 12, 
				y		= 8,
				w		= kMax - 16,
				h		= 40,
				font	= Dialog_TitleFont,
				flags	= kVAlignCenter + kHAlignCenter,
				label	= "#Console",
			},
			
			---------------------------------------------- Body
			KSplit9Image
		    {
			    x		= kCenter - 5,
			    y		= kCenter - 20,
			    image	= "gfx/textfield",
			    w       = 350 - 40,
			    h       = 32,
    			x1 = 10,
    			x2 = 10,
    			y1 = 10,
    			y2 = 10,
    			
			    TextEdit
			    {
				    x		= 3,
				    y		= 5,
				    w		= kMax-3,
				    h		= kMax,
				    font	= {edwardian_medium, 18, BlackColor},
				    name	= "command_textedit",
				    label	= playername,
				    length	= 200,						-- The maximum length
				    --ignore	= kIllegalNameChars,		-- What letters to ignore
				    disable = "ok"						-- What button to disable
			    },
		    },
	        
			---------------------------------------------- Ok
			SetStyle(CSOvalGreenButtonStyle);
            Button
            {
			    x		= kCenter - 60,
                y		= kMax - 80, 
                label	= "app_ok",
                default = true,
			    command =								-- Returns "yes" if pressed
				    function()
				        --DoValueCommand(GetLabel("command_textedit"));
				        DoCommand(GetLabel("command_textedit"));
				    end
            },
            ---------------------------------------------- Cancel
            SetStyle(CSOvalRedButtonStyle);
            Button
            {
			    x		= kCenter + 60,
                y		= kMax - 80,   
                label	= "app_close",
                command	=								-- Returns "no" if pressed
				    function()
				        DoCommand("closeconsole");
                    end
            },
		},
	},
}
SetFocus("command_textedit");